/* - EncoderAttachListener -
 * populate our encoder info fields and enable our editable fields.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.EncoderPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JCheckBox;

public class EncoderAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numEncodersTxt;
    private JTextField numInTxt;
    private JCheckBox inputChk;
    private JTextField relChngTxt;
    private JTextField timeTxt;
    private JTextField posTxt;
    
    /**
     * Creates a new instance of EncoderAttachListener
     */
    public EncoderAttachListener(JFrame appFrame, JTextField attachedTxt,
            JTextArea nameTxt, JTextField serialTxt, JTextField versionTxt,
            JTextField numEncodersTxt, JTextField numInTxt, JCheckBox inputChk,
            JTextField relChngTxt, JTextField timeTxt, JTextField posTxt)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numEncodersTxt = numEncodersTxt;
        this.numInTxt = numInTxt;
        this.inputChk = inputChk;
        this.relChngTxt = relChngTxt;
        this.timeTxt = timeTxt;
        this.posTxt = posTxt;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            EncoderPhidget attached = (EncoderPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numEncodersTxt.setText(Integer.toString(attached.getEncoderCount()));
            numInTxt.setText(Integer.toString(attached.getInputCount()));
            
            if(attached.getInputCount() != 0)
            {
                inputChk.setVisible(true);
            }
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}
